package com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaBasicParameterCollection;

public class MetaQueryAdministrator extends Administrator {
	
	public final static String TAG_NAME = "QueryAdministrator";
	
	private String SQL = "";
	
	private MetaBasicParameterCollection queryParameterCollection = null;
	
	
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {queryParameterCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaQueryAdministrator query = (MetaQueryAdministrator)newInstance();
		query.setSQL(SQL);
		query.setQueryParameterCollection(null == queryParameterCollection ? null : (MetaBasicParameterCollection)queryParameterCollection.clone());
		return query;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaQueryAdministrator();
	}

	public String getSQL() {
		return SQL;
	}

	public void setSQL(String sQL) {
		SQL = sQL;
	}

	public MetaBasicParameterCollection getQueryParameterCollection() {
		return queryParameterCollection;
	}

	public void setQueryParameterCollection(MetaBasicParameterCollection queryParameterCollection) {
		this.queryParameterCollection = queryParameterCollection;
	}

	
}
