package com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMNoKeyCollection;

public class MetaExtendItemMapCollection extends AbstractBPMNoKeyCollection<MetaExtendItemMap> {

	public static final String TAG_NAME = "ExtendItemMapCollection";
	
	private boolean init = false;
	private StringHashMap<MetaExtendItemMap> itemMap = null;
	
	private void init() {
		itemMap = new StringHashMap<MetaExtendItemMap>();
		for(MetaExtendItemMap metaExtendItemMap : this) {
			itemMap.put(metaExtendItemMap.getSourceKey(), metaExtendItemMap);
		}
		init = true;
	}
	
	public MetaExtendItemMap getExtendItemMap(String sourceKey) {
		if(!init) {
			init();
		}
		return itemMap.get(sourceKey);
	}
	
	@Override
	protected MetaExtendItemMap createChildMetaElement(String tagName) {
		MetaExtendItemMap child = null;
		if (tagName.equalsIgnoreCase(MetaExtendItemMap.TAG_NAME))
			child = new MetaExtendItemMap();
		return child;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtendItemMapCollection();
	}
}
