package com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend;

import java.util.Iterator;
import java.util.LinkedList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtendItemCollection extends GenericKeyCollection<MetaExtendItem> {

	public static final String TAG_NAME= "ExtendItemCollection";
	
	private boolean init = false;
	private StringHashMap<MetaExtendItem> map = null;
	
	private void init() {
		map = new StringHashMap<MetaExtendItem>();
		for(MetaExtendItem meta : this) {
			map.put(meta.getKey(), meta);
		}
		init = true;
	}
	
	public MetaExtendItem getExtendItem(String extendItemKey) {
		if(!init) {
			init();
		}
		return map.get(extendItemKey);
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaExtendItem.TAG_NAME)) {
			MetaExtendItem meta = new MetaExtendItem();
			meta.preProcessMetaObject(env, doc, node, flag, runType);
			add(meta);
			child = meta;
		}
		return child;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtendItemCollection();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExtendItemCollection meta = (MetaExtendItemCollection)super.clone();
		return meta;
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray groupArray = new JSONArray();
		Iterator<MetaExtendItem> it = iterator();
		MetaExtendItem extendItem = null;
		while (it.hasNext()) {
			extendItem = it.next();
			groupArray.put(extendItem.toJSON());
		}
		obj.put("extenditems", groupArray);

		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if (json.has("extenditems")) {
			JSONArray groupArray = json.getJSONArray("extenditems");
			for (int i = 0, size = groupArray.length(); i < size; ++i) {
				JSONObject groupObj = groupArray.getJSONObject(i);
				MetaExtendItem extendItem = new MetaExtendItem();
				extendItem.fromJSON(groupObj);
				this.add(extendItem);
			}
		}
	}
	
}
