package com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExConfiguration extends AbstractMetaObject {

	public static final String TAG_NAME = "ExConfiguration";
	
	private MetaExtendItemCollection extendItemCollection = null;
	private MetaExtendItemMapCollection extendItemMapCollection = null;
	
	public MetaExtendItemCollection getExtendItemCollection() {
		return extendItemCollection;
	}
	
	public void setExtendItemCollection(MetaExtendItemCollection extendItemCollection) {
		this.extendItemCollection = extendItemCollection;
	}
	
	public MetaExtendItemMapCollection getExtendItemMapCollection() {
		return extendItemMapCollection;
	}
	
	public void setExtendItemMapCollection(MetaExtendItemMapCollection extendItemMapCollection) {
		this.extendItemMapCollection = extendItemMapCollection;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExConfiguration meta = (MetaExConfiguration)newInstance();
		meta.setExtendItemCollection(extendItemCollection == null ? null : (MetaExtendItemCollection)extendItemCollection.clone());
		meta.setExtendItemMapCollection(extendItemMapCollection == null ? null : (MetaExtendItemMapCollection)extendItemMapCollection.clone()); 
		return meta;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaExtendItemCollection.TAG_NAME)) {
			resultMetaObject = new MetaExtendItemCollection();
			extendItemCollection = (MetaExtendItemCollection)resultMetaObject;
		}else if(tagName.equalsIgnoreCase(MetaExtendItemMapCollection.TAG_NAME)) {
			resultMetaObject = new MetaExtendItemMapCollection();
			extendItemMapCollection = (MetaExtendItemMapCollection)resultMetaObject;
		} 
		return resultMetaObject;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {extendItemCollection, extendItemMapCollection});
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExConfiguration();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		if(extendItemCollection != null) {
			obj.put("extenditemcollection", extendItemCollection.toJSON());
		}
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if(json.has("extenditemcollection")) {
			extendItemCollection = new MetaExtendItemCollection();
			extendItemCollection.fromJSON(json.optJSONObject("extenditemcollection"));
		}
	}
}
