package com.bokesoft.yigo.meta.bpm;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;

/**
 * 业务流程基本元素，仅包含ID、KEY属性。
 * 
 * @author 刘翔翔
 * 
 */
public abstract class AbstractBPMElement extends KeyPairMetaObject {

	/** 元素的唯一数字编号 */
	private Integer ID = -1;

	/** 元素的标识 */
	private String key = "";

	/** 元素的名称 */
	private String caption = "";

	/**
	 * @return 数字编号
	 */
	public Integer getID() {
		return ID;
	}

	/**
	 * 设置节点的数字编号
	 * @param ID 数字编号
	 */
	public void setID(Integer ID) {
		this.ID = ID;
	}

	/**
	 * 设置元素的标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	/**
	 * @return 数字编号
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置节点的名称
	 * @param caption 节点的名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("tag-name", getTagName());
		obj.put("key", key);
		obj.put("id", ID);

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		key = json.optString("key");
		ID = json.optInt("id");
	}

	@Override
	public AbstractMetaObject clone() {
		AbstractBPMElement newElement = (AbstractBPMElement) newInstance();
		newElement.setKey(key);
		newElement.setCaption(caption);
		newElement.setID(ID);
		
		return newElement;
	}

}
