package com.bokesoft.yes.meta.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFrame;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
 
public class MetaFormFrameProcess {
	private IMetaFactory metaFactory = null;
	private MetaForm metaForm = null;
	private MetaForm metaTemp = null;
	private boolean tmpHasToolbar = false;
	private String toolbarKey = null;
	
	public MetaFormFrameProcess(IMetaFactory metaFactory, MetaForm metaForm, MetaForm metaTemp) {
		this.metaFactory = metaFactory;
		this.metaForm = (MetaForm) metaForm.clone();
		this.metaTemp = (MetaForm) metaTemp.clone();	
	}
	
	public MetaForm process() throws Throwable {
		if(metaTemp.getFormType() == FormType.CompDict ||
				metaTemp.getFormType() == FormType.Template){
			return metaForm;
		}
	
		processBody();
		processOpt();
		processDataSource();
		processMacroCollection();	
		processQueryCollection();
		processParaCollection();
		
		this.metaForm.doPostProcess(0, new Callback<AbstractMetaObject, Boolean>() {

			@Override
			public Boolean call(AbstractMetaObject param) throws Throwable {
				if (param instanceof MetaDictProperties) {
					((MetaDictProperties) param).calItemKey(metaForm.getProject().getKey());
				}
				return true;
			}

		});
		
		
		if(tmpHasToolbar){
			for(MetaComponent com : metaForm.getAllComponents()){
				if(com.getControlType() == ControlType.TOOLBAR && !com.getKey().equals(this.toolbarKey)){
					((MetaToolBar)com).setIsDefault(false);
					break;
				}
			}
		}
		
		metaForm.setTemplateKey(metaTemp.getKey());
		
		return metaForm;
		
	}
	
	private void processParaCollection() throws Throwable{
		MetaFormParaCollection para1 = metaForm.getFormParaCollection();
		MetaFormParaCollection para2 = metaTemp.getFormParaCollection();
		MetaFormParaCollection para3 = null;
		if(para2 != null){
			if(para1 != null){
				Iterator<MetaFormPara> it = para2.iterator();
				MetaFormPara p = null;

				String key = null;
				while (it.hasNext()) {
					p = it.next();
					key = p.getKey();
					
					if(para1.get(key) == null){
						para1.add(p);
					}
				}
				para3 = para1;
			}else{
				para3 = para2;
			}
			
			metaForm.setFormParaCollection(para3);
		}
	}
	
	
	//合并宏公式
	private void processQueryCollection() throws Throwable{
		MetaQueryCollection query1 = metaForm.getQueryCollection();
		MetaQueryCollection query2 = metaTemp.getQueryCollection();
		MetaQueryCollection query3 = null;
		if(query2 != null){
			if(query1 != null){
				Iterator<MetaQuery> it = query2.iterator();
				MetaQuery q = null;

				String key = null;
				while (it.hasNext()) {
					q = it.next();
					key = q.getKey();
					
					if(query1.get(key) == null){
						query1.add(q);
					}
				}
				query3 = query1;
			}else{
				query3 = query2;
			}
			
			metaForm.setQueryCollection(query3);
		}
	}
	
	//合并宏公式
	private void processMacroCollection() throws Throwable{
		MetaMacroCollection mac1 = metaForm.getMacroCollection();
		MetaMacroCollection mac2 = metaTemp.getMacroCollection();
		MetaMacroCollection mac3 = null;
		if(mac2 != null){
			if(mac1 != null){
				Iterator<MetaMacro> it = mac2.iterator();
				MetaMacro macro = null;

				String key = null;
				while (it.hasNext()) {
					macro = it.next();
					key = macro.getKey();
					
					if(mac1.get(key) == null){
						mac1.add(macro);
					}
				}
				mac3 = mac1;
			}else{
				mac3 = mac2;
			}
			
			metaForm.setMacroCollection(mac3);
		}
	}
	
	private void processDataSource() throws Throwable{
		MetaDataSource ds1 = metaForm.getDataSource();
		MetaDataSource ds2 = metaTemp.getDataSource();
		
		if(ds2 != null){
			MetaDataSource newDs = null;
			if(ds1 != null){
				MetaDataObjectTemplateUtil util = new MetaDataObjectTemplateUtil(ds2.getDataObject(), ds1.getDataObject(), null, null);
				util.replace();
				newDs = ds1;
			}else{
				newDs = ds2;
			}
			metaForm.setDataSource(newDs);
		}
	}
	
	//合并body
	private void processBody() throws Throwable{
//		boolean hasToolbar = false;
//		for(MetaComponent com : metaTemp.getAllComponents()){
//			if(com.getControlType() == ControlType.TOOLBAR){
//				hasToolbar = true;
//				break;
//			}
//		}
//		
//		if(hasToolbar){
//			for(MetaComponent com : metaForm.getAllComponents()){
//				if(com.getControlType() == ControlType.TOOLBAR){
//					((MetaToolBar)com).setIsDefault(false);
//					break;
//				}
//			}
//		}
//		
//		
		MetaBody metaBody = metaTemp.getMetaBody();
		if(metaBody != null){
			Iterator<MetaComponent> it = metaBody.iterator();
			MetaComponent metaComponent = null;
			while ( it.hasNext() ) {
				metaComponent = it.next();
				if ( metaComponent.isPanel() ) {
					this.processPanel((MetaPanel)metaComponent);
				} else if ( metaComponent.getControlType() == ControlType.BLOCK ) {
					MetaBlock metaBlock = (MetaBlock)metaComponent;
					MetaComponent metaRoot = metaBlock.getRoot();
					if ( metaRoot.isPanel() ) {
						this.processPanel((MetaPanel)metaRoot);
					}
				}
			}
		}
		
		metaForm.setMetaBody((MetaBody) metaBody.clone());
	}
	
	
	//合并操作按钮
	private void processOpt() throws Throwable{
		MetaOperationCollection newOC = null;
		
		MetaOperationCollection oc = metaForm.getOperationCollection();
		MetaOperationCollection oc2 = metaTemp.getOperationCollection();
		if(oc2 != null){
			if(oc != null){
				Iterator<KeyPairCompositeObject> it = oc2.iterator();
				KeyPairCompositeObject metaItem = null;
				
				String key = null;
				while (it.hasNext()) {
					metaItem = it.next();
					key = metaItem.getKey();
					
					if(oc.get(key) == null){
						oc.add(metaItem);
					}
				}
				newOC = oc;
			}else{
				newOC = oc2;
			}
			
			metaForm.setOperationCollection(newOC);
		}
	}
	
	private void processPanel(MetaPanel metaPanel) throws Throwable {
		Iterator<MetaComponent> it = metaPanel.iteratorComponent();
		MetaComponent metaComponent = null;
		ArrayList<MetaComponent> newTemplateComponentArray = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			if ( metaComponent.getControlType() == ControlType.FRAME ) {
				MetaFrame metaFrame = (MetaFrame)metaComponent;
				if(newTemplateComponentArray == null){
					newTemplateComponentArray = new ArrayList<MetaComponent>();
				}

				MetaComponent tmpMetaComponent = null;
				tmpMetaComponent = this.findRoot(metaFrame);

				
				newTemplateComponentArray.add(tmpMetaComponent);

			} else if(metaComponent.getControlType() == ControlType.TOOLBAR){
				tmpHasToolbar = true;
				toolbarKey = metaComponent.getKey();
			} else if ( metaComponent.isPanel() ){
				this.processPanel((MetaPanel)metaComponent);
			} else if ( metaComponent.getControlType() == ControlType.SUBDETAIL ) {
				MetaSubDetail metaSubDetail = (MetaSubDetail)metaComponent;
				MetaComponent root = metaSubDetail.getRoot();
				if( root != null && root.isPanel() ) {
					this.processPanel((MetaPanel) root);
				}
			}
		}
		
		if ( newTemplateComponentArray != null && !newTemplateComponentArray.isEmpty()) {
			LinkedList<MetaComponent> newComponentArray = new LinkedList<MetaComponent>();
			it = metaPanel.iteratorComponent();
			int index = 0;
			while ( it.hasNext() ) {
				metaComponent = it.next();
				if ( metaComponent.getControlType() == ControlType.FRAME ) {
					newComponentArray.add(newTemplateComponentArray.get(index));
					++index;
				} else {
					newComponentArray.add(metaComponent);
				}
			}
			metaPanel.clear();
			it = newComponentArray.iterator();
			while ( it.hasNext() ) {
				metaComponent = it.next();
				metaPanel.addComponent(metaComponent);
			}
		}
	}
	
	private MetaBlock getPrimaryBlock(MetaBody metaBody) throws Throwable {
		MetaBlock metaBlock = null;
	
		if (metaBody.size() == 1) {
			AbstractMetaObject metaFirstElement = metaBody.get(0);
			if (metaFirstElement instanceof MetaBlock) {
				metaBlock = (MetaBlock) metaFirstElement;
			} else {
				
			}
		}

		return metaBlock;
	}
	
	private MetaComponent findRoot(MetaFrame metaFrame) throws Throwable{
		MetaComponent metaRoot = null;
		MetaBody metaBody = metaForm.getMetaBody();
		MetaBlock metaBlock = getPrimaryBlock(metaBody);
		if (metaBlock != null) {
			metaRoot = metaBlock.getRoot();
		}
		
		if(metaRoot != null ){
			metaRoot.setX(metaFrame.getX());
			metaRoot.setXSpan(metaFrame.getXSpan());
			metaRoot.setY(metaFrame.getY());
			metaRoot.setYSpan(metaFrame.getYSpan());
			if(metaRoot instanceof MetaPanel){
				((MetaPanel)metaRoot).setOverflowX(ScrollType.Auto);
				((MetaPanel)metaRoot).setOverflowY(ScrollType.Auto);
			}
		}
		
		return metaRoot;
	}
	
}
