package com.bokesoft.yes.meta.persist.dom.xml.parse;

import java.util.LinkedHashMap;
import java.util.Map;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.ex.XmlSyntaxException;

public class PrivateUtil {
	public static Element getStartTag(String xml, int bgidx) {
		Element tag = new Element();
		tag.type = Element.TAG;

		int lowerIndex = -1;

		int tagNameEndIndex = -1;

		int upperIndex = -1;

		boolean isNodeClose = false;

		boolean findLower = false;

		boolean findingTagName = false;

		boolean foundTagName = false;

		boolean foundAttrs = false;

		boolean foundUpper = false;

		for (int i = bgidx; i < xml.length(); i++) {
			char c = xml.charAt(i);

			if (!findLower) {
				if (c == '<') {
					findLower = true;
					lowerIndex = i;
				}

			} else if (!findingTagName) {
				if (isNameStartChar(c))
					findingTagName = true;
				else {
					throw new XmlSyntaxException("\r\n<符号后面不是正确的标签开始符号[" + c
							+ "]\r\n" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}

			} else if (!foundTagName) {
				if (isNameChar(c))
					continue;
				if (CharUtil.isBlank(c)) {
					foundTagName = true;
					tagNameEndIndex = i;
				} else if ((c == '>') || (c == '/')) {
					foundTagName = true;
					tagNameEndIndex = i;
					i--;
				} else {
					throw new XmlSyntaxException("\r\n寻找标签名称["
							+ xml.substring(lowerIndex, i) + "]过程中,遇到不合法符号["
							+ c + "]\r\n" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}
			} else if (!foundAttrs) {
				Object[] arr = getAttrs(xml, i, new char[] { '/', '>' });
				foundAttrs = true;

				if (arr != null) {
					tag.attrs = ((Map) arr[1]);
					int tem = ((Integer) arr[0]).intValue();
					i = tem - 1;
				} else {
					i--;
				}
			} else {
				if (foundUpper)
					break;
				if (isNodeClose) {
					if (c != '>') {
						throw new XmlSyntaxException("\r\n标签["
								+ xml.substring(lowerIndex, i + 1)
								+ "]没有正确的闭合\r\n" + xml.substring(0, i)
								+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n"
								+ xml.substring(i));
					}
					foundUpper = true;
					upperIndex = i;
				} else if (c == '/') {
					isNodeClose = true;
				} else if (c == '>') {
					foundUpper = true;
					upperIndex = i;
				} else {
					if (CharUtil.isBlank(c))
						continue;
					throw new XmlSyntaxException("\r\n标签["
							+ xml.substring(lowerIndex, i + 1)
							+ "]只能用/> 或>符号来关闭.非法字符[" + c + "]\r\n"
							+ getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}

			}

		}

		if (!findLower) {
			throw new XmlSyntaxException("\r\n没有合法的xml标签[" + xml + "]");
		}

		if (!findingTagName) {
			throw new XmlSyntaxException("\r\n没有开始确认标签名称[" + xml + "]");
		}

		if (!foundTagName) {
			throw new XmlSyntaxException("\r\n标签名称还处于获取中tagName["
					+ xml.substring(lowerIndex) + "]");
		}

		if (!foundUpper) {
			throw new XmlSyntaxException("\r\n标签没有正确的闭合["
					+ xml.substring(lowerIndex) + "]");
		}

		tag.bgIndex = lowerIndex;

		tag.endIndex = upperIndex;
		tag.tagName = xml.substring(lowerIndex + 1, tagNameEndIndex);
		if (isNodeClose)
			tag.tagType = Element.T_NODE;
		else {
			tag.tagType = Element.T_START;
		}

		return tag;
	}

	public static Element getEndTag(String xml, int bg) {
		if ((xml == null) || (xml.length() - bg < 4)) {
			throw new XmlSyntaxException("\r\ngetEndTag [" + xml.substring(bg)
					+ "] 明显不是合法的结尾标签格式.");
		}

		int i = xml.indexOf("</", bg);

		if (i == -1) {
			throw new XmlSyntaxException("\r\ngetEndTag [" + xml.substring(bg)
					+ "] 明显不是合法的结尾标签格式.");
		}
		Element ele = new Element();
		ele.bgIndex = i;

		i += 2;

		boolean findingTagName = false;
		boolean foundTagName = false;
		boolean foundGt = false;

		ele.type = Element.TAG;
		ele.tagType = Element.T_END;

		int nameBg = -1;

		for (; i < xml.length(); i++) {
			char c = xml.charAt(i);

			if (!findingTagName) {
				if (!isNameStartChar(c)) {
					throw new XmlSyntaxException("\r\ngetEndTag: [" + c
							+ "]不是正确的name开始字符\r\n" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}
				findingTagName = true;
				nameBg = i;
			} else if (!foundTagName) {
				if (CharUtil.isBlank(c)) {
					foundTagName = true;
					ele.tagName = xml.substring(nameBg, i);
				} else if (c == '>') {
					foundTagName = true;
					ele.tagName = xml.substring(nameBg, i);

					foundGt = true;
					ele.endIndex = i;
				} else if (!isNameChar(c)) {
					throw new XmlSyntaxException("\r\ngetEndTag: [" + c
							+ "]不是正确的名称字符\r\n" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}
			} else {
				if (foundGt)
					break;
				if (c == '>') {
					foundGt = true;
					ele.endIndex = i;
				} else if (!CharUtil.isBlank(c)) {
					throw new XmlSyntaxException("\r\ngetEndTag: Tag["
							+ ele.tagName + "] 后面遇到不合法的闭合字符[" + c + "]\r\n"
							+ getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}

			}

		}

		return ele;
	}

	public static Object[] getAttrs(String xml, int bgidx, char[] endChars) {
		int argsEndIndex = -1;
		Map<String, String> map = new LinkedHashMap<String, String>();

		int p1 = -1;

		String name = null;
		String value = null;

		char valueStartChar = '0';

		boolean findingName = false;
		boolean foundName = false;
		boolean findEq = false;
		boolean findingValue = false;
		boolean foundValue = false;

		for (int i = bgidx; i < xml.length(); i++) {
			char c = xml.charAt(i);

			if (!findingName) {
				if (isEndChar(c, endChars)) {
					if (map.size() != 0) {
						Object[] tem = new Object[2];
						tem[0] = Integer.valueOf(argsEndIndex);
						tem[1] = map;
						return tem;
					}
					return null;
				}

				if (CharUtil.isBlank(c))
					continue;
				if (isNameStartChar(c)) {
					findingName = true;
					p1 = i;
				} else {
					throw new XmlSyntaxException("\r\n属性名称开始字符不合法[" + c
							+ "]\r\n" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}

			} else if (!foundName) {
				if (isNameChar(c))
					continue;
				if (CharUtil.isBlank(c)) {
					foundName = true;
					name = xml.substring(p1, i);
				} else if (c == '=') {
					foundName = true;
					name = xml.substring(p1, i);
					findEq = true;
				} else {
					throw new XmlSyntaxException("\r\n属性名称遇到不合法字符[" + c
							+ "]\r\n" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}

			} else if (!findEq) {
				if (CharUtil.isBlank(c))
					continue;
				if (c == '=')
					findEq = true;
				else {
					throw new XmlSyntaxException("\r\n获取属性名称后因该有一个=号,现在是非法字符["
							+ c + "]" + getErrorPosInfo(xml, i)
							+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
							//+ xml.substring(i));
				}

			} else if (!findingValue) {
				if (CharUtil.isBlank(c))
					continue;
				if ((c == '"') || (c == '\'')) {
					findingValue = true;
					p1 = i;
					valueStartChar = c;
				} else {
					throw new XmlSyntaxException("\r\ngetArgs:属性[" + name
							+ "]值的开始，因该为[']或[\"].");
				}

			} else if (!foundValue) {
				if (c != valueStartChar)
					continue;
				foundValue = true;
				value = xml.substring(p1 + 1, i);
				map.put(name, value);
			} else if (CharUtil.isBlank(c)) {
				findingName = false;
				foundName = false;
				findEq = false;
				findingValue = false;
				foundValue = false;

				argsEndIndex = i;
			} else {
				if (isEndChar(c, endChars)) {
					Object[] obj = new Object[2];
					obj[0] = Integer.valueOf(i);
					obj[1] = map;
					return obj;
				}

				throw new XmlSyntaxException("\r\n属性[" + name + "]结束后，不能紧跟字符["
						+ c + "]\r\n"  + getErrorPosInfo(xml, i)
						+ "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n" ); // + xml.substring(i));
			}

		}

		if (!findingName) {
			if (map.size() == 0) {
				return null;
			}

			Object[] arr = new Object[2];
			arr[0] = Integer.valueOf(argsEndIndex);
			arr[1] = map;
			return arr;
		}

		if (foundValue) {
			Object[] temArr = new Object[2];
			temArr[0] = Integer.valueOf(xml.length());
			temArr[1] = map;
			return temArr;
		}

		if (!foundName) {
			throw new XmlSyntaxException(
					"\r\nXmlUtil :getStartTag:getArgs:属性名称还没有获取完成["
							+ xml.substring(p1) + "]");
		}
		if (!findEq)
			throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:属性["
					+ name + "] 之后还没有等号");
		if (!findingValue) {
			throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:属性["
					+ name + "] 之后还没有开始获取值.");
		}
		throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:属性["
				+ name + "] 获取值没有完成[" + xml.substring(p1) + "].");
	}

	public static Element getComment(String xml, int bg) {
		return getTextNode(xml, bg, "<!--", "-->", Element.COMMENT);
	}

	public static Element getCDATA(String xml, int bg) {
		return getTextNode(xml, bg, "<![CDATA[", "]]>", Element.CDATA);
	}

	private static Element getTextNode(String xml, int bg, String bgStr,
			String edStr, int elementType) {
		int startIndex = xml.indexOf(bgStr, bg);

		if (startIndex == -1) {
			return null;
		}

		int endIndex = xml.indexOf(edStr, startIndex);

		if (endIndex == -1) {
			throw new XmlSyntaxException("\r\nXmlUtil : getTextNode: ["
					+ xml.substring(startIndex) + "] 没有注释的结束标志");
		}

		Element ele = new Element();
		ele.type = elementType;
		ele.bgIndex = startIndex;
		ele.endIndex = (endIndex + edStr.length() - 1);
		ele.text = xml.substring(ele.bgIndex + bgStr.length(), ele.endIndex
				- (edStr.length() - 1));
		return ele;
	}

	public static Element getDTD(String xml, int bg) {
		TextAnalyzer ay = TextAnalyzer.New();

		Element ele = new Element();
		ele.type = Element.DTD;

		for (int i = bg; i < xml.length(); i++) {
			char c = xml.charAt(i);

			if (CharUtil.isBlank(c))
				continue;
			if (c == '<') {
				if (StringUtil.isString(xml, "<!DOCTYPE", i)) {
					ele.bgIndex = i;
					break;
				}
				return null;
			}

			throw new XmlSyntaxException("\r\nXml未到根节点之前，不能出现字符[" + c + "]\r\n"
					+ getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
					//+ xml.substring(i));
		}

		if (ele.bgIndex == -1) {
			return null;
		}

		Entry e = ay.getBlank(xml, ele.bgIndex + "<!DOCTYPE".length());

		if (e == null) {
			throw new XmlSyntaxException("\r\nDTD不完整["
					+ xml.substring(ele.bgIndex) + "]");
		}

		e = ay.getName(xml, e.getEd() + 1, new char[] { '-', '.', ':' },
				new char[] { '>', '[' });

		if (e == null) {
			throw new XmlSyntaxException("\r\nDTD不完整["
					+ xml.substring(ele.bgIndex) + "]");
		}

		if (xml.charAt(e.getEd() + 1) == '>') {
			ele.endIndex = (e.getEd() + 1);
			return ele;
		}

		if (xml.charAt(e.getEd() + 1) != '[') {
			e = ay.getBlank(xml, e.getEd() + 1);

			if (e.getEd() >= xml.length() - 1) {
				throw new XmlSyntaxException("\r\nDTD不完整["
						+ xml.substring(ele.bgIndex) + "]");
			}
		}

		if (xml.charAt(e.getEd() + 1) == '[') {
			int idx = xml.indexOf("]", e.getEd() + 2);
			if ((idx == -1) || (idx == xml.length() - 1)) {
				throw new XmlSyntaxException("\r\nDTD不完整["
						+ xml.substring(ele.bgIndex) + "]");
			}

			if (xml.charAt(idx + 1) == '>') {
				ele.endIndex = (idx + 1);
				return ele;
			}

			e = ay.getBlank(xml, idx + 1);

			if (e == null) {
				throw new XmlSyntaxException("\r\nDTD不完整["
						+ xml.substring(ele.bgIndex) + "]");
			}

			if (xml.charAt(e.getEd() + 1) == '>') {
				ele.endIndex = (e.getEd() + 1);
				return ele;
			}
			throw new XmlSyntaxException("\r\nDTD["
					+ xml.substring(ele.bgIndex, e.getEd() + 1) + "]因该有一个结束标识>");
		}

		if (StringUtil.isString(xml, "SYSTEM", e.getEd() + 1)) {
			e = ay.getBlank(xml, e.getEd() + 1 + "SYSTEM".length());
			if (e == null) {
				throw new XmlSyntaxException("\r\nDTD不完整["
						+ xml.substring(ele.bgIndex) + "]");
			}

			e = ay.getXmlString(xml, e.getEd() + 1);

			if (e == null) {
				throw new XmlSyntaxException("\r\nDTD不完整["
						+ xml.substring(ele.bgIndex) + "]");
			}

			if (xml.charAt(e.getEd() + 1) == '>') {
				ele.endIndex = (e.getEd() + 1);
				return ele;
			}

			e = ay.getBlank(xml, e.getEd() + 1);
			if (e == null) {
				throw new XmlSyntaxException("\r\nDTD不完整["
						+ xml.substring(ele.bgIndex) + "]");
			}
			if (xml.charAt(e.getEd() + 1) == '>') {
				ele.endIndex = (e.getEd() + 1);
				return ele;
			}
			throw new XmlSyntaxException("\r\nDTD["
					+ xml.substring(ele.bgIndex, e.getEd() + 1) + "]因该有一个结束标识>");
		}

		if (xml.charAt(e.getEd() + 1) == '>') {
			ele.endIndex = (e.getEd() + 1);
			return ele;
		}

		throw new XmlSyntaxException("\r\nDTD["
				+ xml.substring(ele.bgIndex, e.getEd() + 1)
				+ "]元素名称后面只能是[字符或SYSTEM关键字");
	}

	public static boolean isNameStartChar(char c) {
		return CharUtil.isNameStartChar(c);
	}

	public static boolean isNameChar(char c) {
		return (CharUtil.isNameChar(c)) || (c == '-') || (c == '.')
				|| (c == ':');
	}

	private static boolean isEndChar(char c, char[] endChars) {
		for (int i = 0; i < endChars.length; i++) {
			if (c == endChars[i]) {
				return true;
			}
		}
		return false;
	}
	
	public static String getErrorPosInfo(String xml, int pos) {
		int len = pos > 100 ? 100 : pos;
		return xml.substring(pos - len, pos);
	}
}