package com.bokesoft.yes.meta.persist.dom.xml.node;

public class CommentNode extends AbstractNode {

	public CommentNode(String text) {
		super(text);
	}

	@Override
	public String toXml(int level) {
		StringBuilder strBuilder = new StringBuilder();
		appendLevelBlank(strBuilder, level);
		strBuilder.append("<!--").append(getText()).append("-->");
		return strBuilder.toString();
	}

	@Override
	public AbstractNode clone() {
		return new CommentNode(this.getText());
	}

	@Override
	public boolean hasPrimaryAttribute() {
		return false;
	}

}
