package com.bokesoft.yes.meta.persist.dom.timer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.timer.period.WorkDay;

public class WorkDayAction extends BaseDomAction<WorkDay> {

	@Override
	public void load(Document document, Element element, WorkDay meta, int runType) {
		meta.setDayCount(DomHelper.readAttr(element,
				MetaConstants.TIMER_DAY_COUNT, -1));

	}

	@Override
	public void save(Document document, Element element, WorkDay meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TIMER_DAY_COUNT,
				meta.getDayCount(), -1);
	}

}
