package com.bokesoft.yes.meta.persist.dom.timer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.timer.period.Moment;

public class MomentAction extends BaseDomAction<Moment> {

	@Override
	public void load(Document document, Element element, Moment meta, int runType) {
		meta.setHour(DomHelper.readAttr(element, MetaConstants.TIMER_HOUR,
				-1));
		meta.setMinute(DomHelper.readAttr(element,
				MetaConstants.TIMER_MINUTE, -1));
		meta.setSecond(DomHelper.readAttr(element,
				MetaConstants.TIMER_SECOND, -1));
	}

	@Override
	public void save(Document document, Element element, Moment meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TIMER_HOUR,
				meta.getHour(), -1);
		DomHelper.writeAttr(element, MetaConstants.TIMER_MINUTE,
				meta.getMinute(), -1);
		DomHelper.writeAttr(element, MetaConstants.TIMER_SECOND,
				meta.getSecond(), -1);

	}

}
