package com.bokesoft.yes.meta.persist.dom.taskflow;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.taskflow.MetaTaskFlow;
import com.bokesoft.yigo.meta.taskflow.node.MetaCompensation;
import com.bokesoft.yigo.meta.taskflow.node.MetaCondition;
import com.bokesoft.yigo.meta.taskflow.node.MetaEnd;
import com.bokesoft.yigo.meta.taskflow.node.MetaFork;
import com.bokesoft.yigo.meta.taskflow.node.MetaInputParas;
import com.bokesoft.yigo.meta.taskflow.node.MetaJoin;
import com.bokesoft.yigo.meta.taskflow.node.MetaNodeCollection;
import com.bokesoft.yigo.meta.taskflow.node.MetaPara;
import com.bokesoft.yigo.meta.taskflow.node.MetaSequenceFlow;
import com.bokesoft.yigo.meta.taskflow.node.MetaSequenceFlows;
import com.bokesoft.yigo.meta.taskflow.node.MetaStart;
import com.bokesoft.yigo.meta.taskflow.node.MetaState;
import com.bokesoft.yigo.meta.taskflow.node.MetaStyle;
import com.bokesoft.yigo.meta.taskflow.node.MetaTask;

public class MetaTaskFlowActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
			{MetaEnd.TAG_NAME, new MetaEndAction()},
			{MetaFork.TAG_NAME, new MetaForkAction()},
			{MetaJoin.TAG_NAME, new MetaJoinAction()},
			{MetaInputParas.TAG_NAME, new MetaInputParasAction()},
			{MetaPara.TAG_NAME, new MetaParaAction()},
			{MetaSequenceFlow.TAG_NAME, new MetaSequenceFlowAction()},
			{MetaSequenceFlows.TAG_NAME, new MetaSequenceFlowsAction()},
			{MetaStart.TAG_NAME, new MetaStartAction()},
			{MetaStyle.TAG_NAME, new MetaStyleAction()},
			{MetaTaskFlow.TAG_NAME, new MetaTaskFlowAction()},
			{MetaTask.TAG_NAME, new MetaTaskAction()},
			{MetaCondition.TAG_NAME, new MetaConditionAction()},
			{MetaCompensation.TAG_NAME, new MetaCompensationAction()},
			{MetaState.TAG_NAME, new MetaStateAction()},
			{MetaNodeCollection.TAG_NAME, new MetaNodeCollectionAction()}
		};
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
	
	private static MetaTaskFlowActionMap INSTANCE = null;
	
	public static MetaTaskFlowActionMap getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new MetaTaskFlowActionMap();
		}
		return INSTANCE;
	}
}

