package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaTrigger;

public class MetaTriggerAction extends BaseDomAction<MetaTrigger>{

	@Override
	public void load(Document document, Element element, MetaTrigger meta,
			int runType) {
		meta.setName(DomHelper.readAttr(element, MetaConstants.TRIGGER_NAME, ""));
		meta.setGroup(DomHelper.readAttr(element, MetaConstants.TRIGGER_GROUP, ""));
		meta.setDelay(DomHelper.readAttr(element, MetaConstants.TRIGGER_DELAY, 0));
		meta.setRepeatCount(DomHelper.readAttr(element, MetaConstants.REPEAT_COUNT, -1));
		meta.setRepeatInterval(DomHelper.readAttr(element, MetaConstants.REPEAT_INTERVAL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTrigger meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.TRIGGER_NAME, meta.getName(), "");
		DomHelper.writeAttr(element, MetaConstants.TRIGGER_GROUP, meta.getGroup(), "");
		DomHelper.writeAttr(element, MetaConstants.TRIGGER_DELAY, meta.getDelay(), 0);
		DomHelper.writeAttr(element, MetaConstants.REPEAT_COUNT, meta.getRepeatCount(), -1);
		DomHelper.writeAttr(element, MetaConstants.REPEAT_INTERVAL, meta.getRepeatInterval(), "");
	}

}
