package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.solution.MetaProjectFold;

public class MetaProjectFoldAction extends BaseDomAction<AbstractMetaObject> {

	@Override
	public void load(Document document, Element element, AbstractMetaObject meta, int runType) {
		MetaProjectFold metaProjectFold = (MetaProjectFold)meta;
		metaProjectFold.setKey(DomHelper.readAttr(element, "Key", ""));
		metaProjectFold.setCaption(DomHelper.readAttr(element, "Caption", ""));
	}

	@Override
	public void save(Document document, Element element, AbstractMetaObject meta, int runType) {
		MetaProjectFold metaProjectFold = (MetaProjectFold)meta;
		DomHelper.writeAttr(element, "Key", metaProjectFold.getKey(), "");
		DomHelper.writeAttr(element, "Caption", metaProjectFold.getCaption(), "");
	}

}
