package com.bokesoft.yes.meta.persist.dom.solution;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaDataObjectScanLoad extends BaseMetaScanLoad {
	private MetaDataObjectList dataObjectList = null;
	private MetaProject metaProject = null;
	public MetaDataObjectScanLoad(MetaDataObjectList dataObjectList, IMetaResolver resolver,
			MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.DATAOBJECT_FOLD, context);
		this.dataObjectList = dataObjectList;
		this.metaProject = metaProject;
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataObjectProfile profile) {
		
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaDataObject.TAG_NAME.equals(tagName)) {
				MetaDataObjectProfile metaDataObjectProfile = new MetaDataObjectProfile();
				metaDataObjectProfile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				metaDataObjectProfile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				metaDataObjectProfile.setExtend(profileInfo.optString(MetaConstants.FORM_EXTEND));

				String primaryType = profileInfo.optString(MetaConstants.DATAOBJECT_PRIMARYTYPE);
				if ( primaryType != null && !primaryType.isEmpty() ) {
					metaDataObjectProfile.setPrimaryType(DataObjectPrimaryType.parse(primaryType));
				}
				String secondaryType = profileInfo.optString(MetaConstants.DATAOBJECT_SECONDARYTYPE);
				if(secondaryType != null && !secondaryType.isEmpty()){
					metaDataObjectProfile.setSecondaryType(DataObjectSecondaryType.parse(secondaryType));
				}
				
				metaDataObjectProfile.setResource(filePath);
				metaDataObjectProfile.setProject(metaProject);
				if ( dataObjectList.containsKey(metaDataObjectProfile.getKey())) {
					MetaDataObjectProfile tmpDataObjectProfile = dataObjectList.get(metaDataObjectProfile.getKey());
					IMetaProject tmpProject = tmpDataObjectProfile.getProject();
					throw new MetaException(MetaException.REPEAT_DATAOBJECT_DEFINED,
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatDataObjectDefined), 
									metaProject.getKey(), "", metaDataObjectProfile.getKey(),
									tmpProject.getKey(), tmpDataObjectProfile.getFormKey()));
				}
				doFind(parent, parentPath, filePath, fileName, metaDataObjectProfile);
				dataObjectList.add(metaDataObjectProfile);
			}
		}
	}

}
