package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaDataMigrationScanLoad extends
		BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private MetaDataMigrationList migrationList = null;
	private Map<String, MetaDataMigrationProfile> map = null;
	public MetaDataMigrationScanLoad(
			MetaDataMigrationList migrationList, IMetaResolver resolver,  
			MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.DATAMIGRATION_FOLD, context);
		this.migrationList = migrationList;
		this.runType = runType;
		map = new ConcurrentHashMap<>();
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMigrationProfile profile) {
		
	}
	
	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			MetaDataMigrationProfile metaDataMigrationProfile = new MetaDataMigrationProfile();
			if (MetaDataMigration.TAG_NAME.equals(tagName)) {
				metaDataMigrationProfile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				metaDataMigrationProfile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				metaDataMigrationProfile.setExtend(profileInfo.optString(MetaConstants.FORM_EXTEND));
				metaDataMigrationProfile.setSrcDataObjectKey(profileInfo.optString(MetaDMConstants.SRC_DATAOBJECT_KEY));
				metaDataMigrationProfile.setTgtDataObjectKey(profileInfo.optString(MetaDMConstants.TGT_DATAOBJECT_KEY));
				metaDataMigrationProfile.setDescription(profileInfo.optString(MetaDMConstants.DEFINITION));
				metaDataMigrationProfile.setStatusFieldKey(profileInfo.optString(MetaDMConstants.STATUSKEY));
				metaDataMigrationProfile.setStatusValue(profileInfo.optString(MetaDMConstants.STATUSVALUE));
				metaDataMigrationProfile.setCondition(profileInfo.optString(MetaDMConstants.DM_CONDITION));
				metaDataMigrationProfile.setProject(metaProject);
				metaDataMigrationProfile.setResource(filePath);
				if ( map.containsKey(metaDataMigrationProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_DATA_MIGRATION_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatDataMigrationDefined),
									metaProject.getKey(), metaDataMigrationProfile.getKey()));
				}
				doFind(parent, parentPath, filePath, fileName, metaDataMigrationProfile);
				map.put(metaDataMigrationProfile.getKey(), metaDataMigrationProfile);
			}
		}
	}

	public int getRunType() {
		return runType;
	}

	private void merge() {
		if(map.isEmpty()) {
			return;
		}
		try {
			map.values().forEach(profile -> {
				this.migrationList.add(profile);
			});
		}finally {
			map.clear();
		}
	}
	
	public MetaDataMigrationList getMetaDataMigrationList() {
		merge();
		return this.migrationList;
	}
}
