package com.bokesoft.yes.meta.persist.dom.solution;

import java.io.InputStream;

import org.xml.sax.Attributes;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomSAXReader;
import com.bokesoft.yigo.common.dom.IDomSAXReaderListener;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagram;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramList;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramProfile;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramSubList;

import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaBusinessDiagramScanLoad  extends BaseMetaScanLoad {
	
	private MetaBusinessDiagramList lstMetaBD = null;
	
/*	public MetaBusinessDiagramScanLoad(MetaExcelTemplateList excelTemplateList, IMetaResolver resolver,
			MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.EXCELTEMPLATE_FOLD, context);
		this.excelTemplateList = excelTemplateList;
	}*/

/*	public MetaBusinessDiagramScanLoad(MetaBusinessDiagramList lstMetaBD,
			IMetaResolver projectMetaResolver, MetaProject metaProject,
			ResFold businessDiagramRootFold, int dev) {
		super(projectMetaResolver, metaProject, DomMetaConstants.BUSINESSDIAGRAM_FOLD, context);
		this.lstMetaBD = lstMetaBD;
	}*/
	
	public MetaBusinessDiagramScanLoad(MetaBusinessDiagramList lstMetaBD, IMetaResolver resolver,
			MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.BUSINESSDIAGRAM_FOLD, context);
		this.lstMetaBD = lstMetaBD;
	}


	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName)
			throws Exception {
		DomSAXReader reader = new DomSAXReader(parent, new IDomSAXReaderListener() {

			@Override
			public void startElement(Object parent, String resource, String uri,
					String localName, String qName, Attributes attributes) {
				if (MetaBusinessDiagram.TAG_NAME.equals(qName)) {
					MetaBusinessDiagramProfile profile = new MetaBusinessDiagramProfile();
					profile.setKey(attributes.getValue(MetaConstants.COMMON_KEY));
					profile.setCaption(attributes.getValue(MetaConstants.COMMON_CAPTION));
					
					String projectKey = metaProject.getKey();
					profile.setProject(metaProject);
					profile.setResource(resource);
					MetaBusinessDiagramSubList subList = lstMetaBD.get(projectKey);
					if ( subList == null ) {
						subList = new MetaBusinessDiagramSubList();
						subList.setKey(projectKey);
					}
					subList.add(profile);
					lstMetaBD.add(subList);
				}
			}

			@Override
			public void endElement(String uri, String localName, String qName) {
			}

			@Override
			public boolean stopParse(boolean startElement, String tagName) {
				return true;
			}

		});
		InputStream in = resolver.read(filePath, 0);
		try {
			reader.start(in, filePath);
		} finally {
			if (in != null) {
				in.close();
			}
		}
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaBusinessDiagramProfile profile) {
		
	}

}
