package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.setting.MetaMigrationSetting;

public class MetaMigrationSettingAction extends BaseDomAction<MetaMigrationSetting> {

	@Override
	public void load(Document document, Element element, MetaMigrationSetting meta, int runType) {
		meta.setUseOptimization(DomHelper.readAttr(element, BPMConstants.USE_OPTIMIZATION, true));
	}

	@Override
	public void save(Document document, Element element, MetaMigrationSetting meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.USE_OPTIMIZATION, meta.isUseOptimization(), true);
	}

}
