package com.bokesoft.yes.meta.persist.dom.report.embed;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.ReportCellPageNo;
import com.bokesoft.yigo.meta.report.ReportCellSystemField;
import com.bokesoft.yigo.meta.report.ReportContentSourceType;
import com.bokesoft.yigo.meta.report.embed.MetaReportText;

public class MetaReportTextAction extends MetaReportEmbedObjectAction<MetaReportText> {

	@Override
	public void load(Document document, Element element, MetaReportText meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setSourceType(ReportContentSourceType.parse(DomHelper.readAttr(element, MetaReportConstants.CONTENT_SOURCE_TYPE, ReportContentSourceType.STR_Const)));
		meta.setTableKey(DomHelper.readAttr(element, MetaReportConstants.CONTENT_TABLE_KEY, ""));
		meta.setFieldKey(DomHelper.readAttr(element, MetaReportConstants.CONTENT_FIELD_KEY, ""));
		meta.setFormula(DomHelper.readAttr(element, MetaReportConstants.CONTENT_FORMULA, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaReportConstants.CONTENT_IMPL, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.FORMAT_BACKCOLOR, ""));
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.FORMAT_FORECOLOR, "#000000"));
		meta.setFillEmptyContent(DomHelper.readAttr(element, MetaReportConstants.CELL_FILL_EMPTY_CONTENT, false));
		meta.setPageNo(ReportCellPageNo.parse(DomHelper.readAttr(element, MetaReportConstants.CONTENT_PAGENO, "")));
		meta.setSystemContent(ReportCellSystemField.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_SYSTEM_CONTENT, "")));
	}

	@Override
	public void save(Document document, Element element, MetaReportText meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_SOURCE_TYPE, ReportContentSourceType.toString(meta.getSourceType()), ReportContentSourceType.STR_Const);
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_TABLE_KEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_FIELD_KEY, meta.getFieldKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_FORECOLOR, meta.getForeColor(), "#000000");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_FILL_EMPTY_CONTENT, meta.isFillEmptyContent(), false);
		DomHelper.writeAttr(element, MetaReportConstants.CONTENT_PAGENO, ReportCellPageNo.toString(meta.getPageNo()), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_SYSTEM_CONTENT, ReportCellPageNo.toString(meta.getSystemContent()), "");

	}

}
