package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportGridRow;
import com.bokesoft.yigo.meta.report.ReportRowType;

public class MetaReportGridRowAction extends BaseDomAction<MetaReportGridRow> {

	@Override
	public void load(Document document, Element element, MetaReportGridRow meta, int runType) {
		meta.setType(ReportRowType.parse(DomHelper.readAttr(element, MetaReportConstants.ROW_TYPE, "")));
		meta.setHeight(DomHelper.readAttr(element, MetaReportConstants.ROW_HEIGHT, 0));
		meta.setTableKey(DomHelper.readAttr(element, MetaReportConstants.ROW_TABLE_KEY, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
		meta.setLineBreak(DomHelper.readAttr(element, MetaReportConstants.ROW_LINE_BREAK, false));
		meta.setPageBreak(DomHelper.readAttr(element, MetaReportConstants.ROW_PAGE_BREAK, false));
		meta.setGroupKey(DomHelper.readAttr(element, MetaReportConstants.ROW_GROUP_KEY, ""));
		meta.setGroupLevel(DomHelper.readAttr(element, MetaReportConstants.ROW_GROUP_LEVEL, -1));
		meta.setDtlCountEveryPage(DomHelper.readAttr(element, MetaReportConstants.ROW_DtlCOUNTEVERYPAGE, 0));
		meta.setFilter(DomHelper.readAttr(element, MetaReportConstants.ROW_FILTER, ""));
	}

	@Override
	public void save(Document document, Element element, MetaReportGridRow meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.ROW_TYPE, ReportRowType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaReportConstants.ROW_HEIGHT, meta.getHeight(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.ROW_TABLE_KEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaReportConstants.ROW_LINE_BREAK, meta.isLineBreak(), false);
		DomHelper.writeAttr(element, MetaReportConstants.ROW_PAGE_BREAK, meta.isPageBreak(), false);
		DomHelper.writeAttr(element, MetaReportConstants.ROW_GROUP_KEY, meta.getGroupKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.ROW_GROUP_LEVEL, meta.getGroupLevel(), -1);
		DomHelper.writeAttr(element, MetaReportConstants.ROW_DtlCOUNTEVERYPAGE, meta.getDtlCountEveryPage(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.ROW_FILTER, meta.getFilter(), "");
	}

}
