package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportDataField;

public class MetaReportDataFieldAction extends BaseDomAction<MetaReportDataField> {

	@Override
	public void load(Document document, Element element,
			MetaReportDataField meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDBFieldKey(DomHelper.readAttr(element, MetaReportConstants.FIELD_DB_FIELD_KEY, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaReportDataField meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaReportConstants.FIELD_DB_FIELD_KEY, meta.getDBFieldKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
	}

}
