package com.bokesoft.yes.meta.persist.dom.mobiledef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;

public class MetaWatermarkAction extends BaseDomAction<MetaWatermark>{
	
	@Override
	public void load(Document document, Element element, MetaWatermark meta, int runType) {
		meta.setDensity(DomHelper.readInt(element, MetaConstants.WATERMARK_DENSITY, 50));
		String rotate = DomHelper.readAttr(element, MetaConstants.WATERMARK_ROTATE, "-30");
		if(rotate != null && !rotate.isEmpty()){
			meta.setRotate(Float.parseFloat(rotate));
		}
		meta.setFormulaText(DomHelper.readAttr(element, MetaConstants.WATERMARK_FORMULATEXT, ""));
	}

	@Override
	public void save(Document document, Element element, MetaWatermark meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.WATERMARK_DENSITY, meta.getDensity() + "", "50");
		DomHelper.writeAttr(element, MetaConstants.WATERMARK_ROTATE, meta.getRotate() + "", "-30");
		DomHelper.writeAttr(element, MetaConstants.WATERMARK_FORMULATEXT, meta.getFormulaText(), "");
	}
}