package com.bokesoft.yes.meta.persist.dom.mobiledef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EventDefType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mobiledef.MetaEventDef;

public class MetaEventDefAction extends BaseDomAction<MetaEventDef>{

	@Override
	public void load(Document document, Element element, MetaEventDef meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setType(EventDefType.parse(DomHelper.readAttr(element, MetaConstants.EVENTDEF_TYPE, EventDefType.Str_Signal)));
	}

	@Override
	public void save(Document document, Element element, MetaEventDef meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.EVENTDEF_TYPE, EventDefType.toString(meta.getType()), EventDefType.Str_Signal);
	}

}
