package com.bokesoft.yes.meta.persist.dom.mapping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mapping.MetaNormalNode;

public class MetaNormalNodeAction extends MetaNodeAction<MetaNormalNode> {

	@Override
	public void load(Document document, Element element, MetaNormalNode meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setDataObjectKey(DomHelper.readAttr(element, MetaMappingConstants.DATAOBJECT, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaMappingConstants.DATATYPE, "")));
	}

	@Override
	public void save(Document document, Element element, MetaNormalNode meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaMappingConstants.DATAOBJECT, meta.getDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.DATATYPE, DataType.toString(meta.getDataType()), "");
	}

}
