package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;

public class MetaLayoutSplitItemAction extends MetaLayoutItemAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaLayoutSplitItem metaLayoutSplitItem = (MetaLayoutSplitItem)meta;
		metaLayoutSplitItem.setSize(DefSize.parse(DomHelper.readAttr(element, MetaConstants.SPLITPANEL_SIZE, "")));
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaLayoutSplitItem metaLayoutSplitItem = (MetaLayoutSplitItem)meta;
		DefSize size = metaLayoutSplitItem.getSize();
		if ( size != null ) {
			DomHelper.writeAttr(element, MetaConstants.SPLITPANEL_SIZE, size.toString(), "");
		}
	}
}
