package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;

public class MetaLayoutSpanAction extends MetaLayoutItemAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaLayoutSpan metaLayoutSpan = (MetaLayoutSpan)meta;
		metaLayoutSpan.setX(DomHelper.readAttr(element, MetaConstants.COMPONENT_X, -1));
		metaLayoutSpan.setY(DomHelper.readAttr(element, MetaConstants.COMPONENT_Y, -1));
		metaLayoutSpan.setXSpan(DomHelper.readAttr(element, MetaConstants.COMPONENT_XSPAN, 1));
		metaLayoutSpan.setYSpan(DomHelper.readAttr(element, MetaConstants.COMPONENT_YSPAN, 1));
		String heightStr = DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, "");
		if(!heightStr.isEmpty()){
			metaLayoutSpan.setHeight(DefSize.parse(heightStr));
		}
		String widthStr = DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "");
		if(!widthStr.isEmpty()){
			metaLayoutSpan.setWidth(DefSize.parse(widthStr));
		}
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaLayoutSpan metaLayoutSpan = (MetaLayoutSpan)meta;
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_X, metaLayoutSpan.getX(), -1);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_Y, metaLayoutSpan.getY(), -1);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_XSPAN, metaLayoutSpan.getXSpan(), 1);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_YSPAN, metaLayoutSpan.getYSpan(), 1);
		DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, 
				metaLayoutSpan.getHeight() != null ? metaLayoutSpan.getHeight().toString() : "", "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, 
				metaLayoutSpan.getWidth() != null ? metaLayoutSpan.getWidth().toString() : "", "");
	}
}
