package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;

public class MetaComponentLayoutAction extends BaseDomAction<AbstractMetaObject> {

	@Override
	public void load(Document document, Element element,
			AbstractMetaObject metaObject, int runType) {
		MetaComponentLayout<?> meta = (MetaComponentLayout<?>)metaObject;
		
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		
		meta.setPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_PADDING, ""));
		meta.setTopPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPPADDING, ""));
		meta.setRightPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, ""));
		meta.setBottomPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, ""));
		meta.setLeftPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTPADDING, ""));
		
		meta.setMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_MARGIN, ""));
		meta.setTopMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPMARGIN, ""));
		meta.setRightMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, ""));
		meta.setBottomMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, ""));
		meta.setLeftMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, ""));
		
		meta.setBorderColor(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERCOLOR, ""));
		meta.setBorderRadius(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERRADIUS, ""));
		meta.setBorderWidth(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERWIDTH, ""));
		meta.setBorderStyle(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERSTYLE, ""));
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject metaObject, int runType) {
		MetaComponentLayout<?> meta = (MetaComponentLayout<?>)metaObject;
		
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_PADDING, meta.getPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOPPADDING, meta.getTopPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, meta.getRightPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, meta.getBottomPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFTPADDING, meta.getLeftPadding(), "");
		
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_MARGIN, meta.getMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOPMARGIN, meta.getTopMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, meta.getRightMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, meta.getBottomMargin(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, meta.getLeftMargin(), "");
		
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERCOLOR, meta.getBorderColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERRADIUS, meta.getBorderRadius(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERWIDTH, meta.getBorderWidth(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERSTYLE, meta.getBorderStyle(), "");
	}

}
