package com.bokesoft.yes.meta.persist.dom.form.component.panel.gridpanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;

public class MetaColumnDefAction extends BaseDomAction<MetaColumnDef> {
	@Override
	public void load(Document document, Element element, MetaColumnDef meta,
					 int runType) {
		String width = DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, DefSize.STR_Auto);
		if (width != null && !width.isEmpty()) {
			meta.setWidth(DefSize.parse(width));
		} else {
			meta.setWidth(new DefSize(-1, 0));
		}
		String minWidth = DomHelper.readAttr(element, MetaConstants.COMMON_MINWIDTH, "");
		if ( minWidth != null && !minWidth.isEmpty() ) {
			meta.setMinWidth(DefSize.parse(minWidth));
		} else {
			meta.setMinWidth(null);
		}
		String zhCHT_Width = DomHelper.readAttr(element, MetaConstants.ZHCHT_WIDTH, "");
		if ( zhCHT_Width != null && !zhCHT_Width.isEmpty() ) {
			meta.setZhCHT_Width(DefSize.parse(zhCHT_Width));
		} else {
			meta.setZhCHT_Width(null);
		}
		String enUS_Width = DomHelper.readAttr(element, MetaConstants.ENUS_WIDTH, "");
		if ( enUS_Width != null && !enUS_Width.isEmpty() ) {
			meta.setEnUS_Width(DefSize.parse(enUS_Width));
		} else {
			meta.setEnUS_Width(null);
		}
		String ruRU_Width = DomHelper.readAttr(element, MetaConstants.RURU_WIDTH, "");
		if ( ruRU_Width != null && !ruRU_Width.isEmpty() ) {
			meta.setRuRU_Width(DefSize.parse(ruRU_Width));
		} else {
			meta.setRuRU_Width(null);
		}
		String jaJP_Width = DomHelper.readAttr(element, MetaConstants.JAJP_WIDTH, "");
		if ( jaJP_Width != null && !jaJP_Width.isEmpty() ) {
			meta.setJaJP_Width(DefSize.parse(jaJP_Width));
		} else {
			meta.setJaJP_Width(null);
		}
		String frFR_Width = DomHelper.readAttr(element, MetaConstants.FRFR_WIDTH, "");
		if ( frFR_Width != null && !frFR_Width.isEmpty() ) {
			meta.setFrFR_Width(DefSize.parse(frFR_Width));
		} else {
			meta.setFrFR_Width(null);
		}
		String esES_Width = DomHelper.readAttr(element, MetaConstants.ESES_WIDTH, "");
		if ( esES_Width != null && !esES_Width.isEmpty() ) {
			meta.setEsES_Width(DefSize.parse(esES_Width));
		} else {
			meta.setEsES_Width(null);
		}
		String ptPT_Width = DomHelper.readAttr(element, MetaConstants.PTPT_WIDTH, "");
		if ( ptPT_Width != null && !ptPT_Width.isEmpty() ) {
			meta.setPtPT_Width(DefSize.parse(ptPT_Width));
		} else {
			meta.setPtPT_Width(null);
		}
		String deDE_Width = DomHelper.readAttr(element, MetaConstants.DEDE_WIDTH, "");
		if ( deDE_Width != null && !deDE_Width.isEmpty() ) {
			meta.setDeDE_Width(DefSize.parse(deDE_Width));
		} else {
			meta.setDeDE_Width(null);
		}
		String arAE_Width = DomHelper.readAttr(element, MetaConstants.ARAE_WIDTH, "");
		if ( arAE_Width != null && !arAE_Width.isEmpty() ) {
			meta.setArAE_Width(DefSize.parse(arAE_Width));
		} else {
			meta.setArAE_Width(null);
		}
	}

	@Override
	public void save(Document document, Element element, MetaColumnDef meta,
					 int runType) {
		DefSize width = meta.getWidth();
		if ( width != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), DefSize.STR_Auto);
		}
		DefSize minWidth = meta.getMinWidth();
		if ( minWidth != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_MINWIDTH, minWidth.toString(), "");
		}
		DefSize zhCHT_Width = meta.getZhCHT_Width();
		if ( zhCHT_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.ZHCHT_WIDTH, zhCHT_Width.toString(), "");
		}
		DefSize enUS_Width = meta.getEnUS_Width();
		if ( enUS_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.ENUS_WIDTH, enUS_Width.toString(), "");
		}
		DefSize ruRU_Width = meta.getRuRU_Width();
		if ( ruRU_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.RURU_WIDTH, ruRU_Width.toString(), "");
		}
		DefSize jaJP_Width = meta.getJaJP_Width();
		if ( jaJP_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.JAJP_WIDTH, jaJP_Width.toString(), "");
		}
		DefSize frFR_Width = meta.getFrFR_Width();
		if ( frFR_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.FRFR_WIDTH, frFR_Width.toString(), "");
		}
		DefSize esES_Width = meta.getEsES_Width();
		if ( esES_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.ESES_WIDTH, esES_Width.toString(), "");
		}
		DefSize ptPT_Width = meta.getPtPT_Width();
		if ( ptPT_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.PTPT_WIDTH, ptPT_Width.toString(), "");
		}
		DefSize deDE_Width = meta.getDeDE_Width();
		if ( deDE_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.DEDE_WIDTH, deDE_Width.toString(), "");
		}
		DefSize arAE_Width = meta.getArAE_Width();
		if ( arAE_Width != null ) {
			DomHelper.writeAttr(element, MetaConstants.ARAE_WIDTH, arAE_Width.toString(), "");
		}

	}
}
