package com.bokesoft.yes.meta.persist.dom.form.component.control.wizardlist;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.WizardItemListSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemList;

public class MetaWizardItemListAction extends BaseDomAction<MetaWizardItemList> {

	@Override
	public void load(Document document, Element element, MetaWizardItemList meta, int runType) {
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.WIZARDLIST_TABLEKEY, ""));
		meta.setSourceType(WizardItemListSourceType.parse(
				DomHelper.readAttr(element, MetaConstants.WIZARDLIST_SOURCETYPE, WizardItemListSourceType.STR_Data)));
	}

	@Override
	public void save(Document document, Element element, MetaWizardItemList meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.WIZARDLIST_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.WIZARDLIST_SOURCETYPE,
				WizardItemListSourceType.toString(meta.getSourceType()), WizardItemListSourceType.STR_Data);
	}

}
