package com.bokesoft.yes.meta.persist.dom.form.component.control.treeview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TreeDataSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.treeview.MetaTreeViewDataSource;

public class MetaTreeViewDataSourceAction extends BaseDomAction<MetaTreeViewDataSource> {

	public void save(Document document, Element element, MetaTreeViewDataSource meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, 
				TreeDataSourceType.toString(meta.getType()), null);
		DomHelper.writeAttr(element, MetaConstants.TREEVIEW_DATASOURCE_ITEMKEY, meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TREEVIEW_DATASOURCE_FORMULAITEMKEY, meta.getFormulaItemKey(), "");
	}

	public void load(Document document, Element element, MetaTreeViewDataSource meta, int runType) {		
		meta.setType(TreeDataSourceType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, "")));
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.TREEVIEW_DATASOURCE_ITEMKEY, ""));
		meta.setFormulaItemKey(DomHelper.readAttr(element, MetaConstants.TREEVIEW_DATASOURCE_FORMULAITEMKEY, ""));
	}

}
