package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;

public class MetaCheckBoxExtPropertiesAction extends DomPropertiesAction<MetaCheckBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaCheckBoxProperties meta, int runType) { 
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICON, null));
		meta.setSelectedIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_SELECTEDICON, null));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, "")));
		meta.setHideButton(DomHelper.readAttr(element, MetaConstants.CHECKBOX_HIDEBUTTON, false));
		meta.setCheckedType(DomHelper.readAttr(element, MetaConstants.CHECKBOX_CHECKEDTYPE, null));
		meta.setUnCheckedType(DomHelper.readAttr(element, MetaConstants.CHECKBOX_UNCHECKEDTYPE, null));
		meta.setEnableHalfCheck(DomHelper.readBool(element, MetaConstants.CHECKBOX_ENABLEHALFCHECK, null));
		meta.setEnableCheckAll(DomHelper.readBool(element, MetaConstants.CHECKBOX_ENABLECHECKALL, null));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaCheckBoxProperties meta, int runType) { 
		
	}

}
