package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;

public class MetaTextButtonPropertiesAction extends DomPropertiesAction<MetaTextButtonProperties> {

	@Override
	public void loadImpl(Document document, Element element,
						 MetaTextButtonProperties meta, int runType) {
		meta.setMaxLength(DomHelper.readAttr(element, MetaConstants.TEXT_MAXLENGTH, 255));
		meta.setCaseType(MetaTextEditor.parseCaseType(DomHelper.readAttr(element, MetaConstants.TEXT_CASE, "None")));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, ""));
		meta.setInvalidChars(DomHelper.readAttr(element, MetaConstants.TEXT_INVALIDCHARS, ""));
		meta.setTrim(DomHelper.readAttr(element, MetaConstants.TEXT_TRIM, false));
		meta.setSelectOnFocus(DomHelper.readAttr(element, MetaConstants.TEXT_SELECTONFOCUS, true));
		meta.setMask(DomHelper.readAttr(element, MetaConstants.TEXT_MASK, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.TEXT_ICON, ""));
		meta.setPreIcon(DomHelper.readAttr(element, MetaConstants.TEXT_PREICON, ""));
		meta.setEmbedText(DomHelper.readAttr(element, MetaConstants.TEXT_EMBEDTEXT, ""));
		meta.setHoldFocus(DomHelper.readAttr(element, MetaConstants.TEXT_HOLDFOCUS, false));
		meta.setUseFormulaModel(DomHelper.readBool(element, MetaConstants.TEXT_USEFORMULAMODEL, false));
	}

	@Override
	public void saveImpl(Document document, Element element,
						 MetaTextButtonProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TEXT_MAXLENGTH, meta.getMaxLength(), 255);
		DomHelper.writeAttr(element, MetaConstants.TEXT_CASE, MetaTextEditor.getCaseTypeStr(meta.getCaseType()), "None");
		DomHelper.writeAttr(element, MetaConstants.TEXT_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.TEXT_INVALIDCHARS, meta.getInvalidChars(), "");
		DomHelper.writeAttr(element, MetaConstants.TEXT_TRIM, meta.isTrim(),false);
		DomHelper.writeAttr(element, MetaConstants.TEXT_SELECTONFOCUS, meta.isSelectOnFocus(),true);
		DomHelper.writeAttr(element, MetaConstants.TEXT_MASK, meta.getMask(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_ICON, meta.getIcon(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_PREICON, meta.getPreIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.TEXT_EMBEDTEXT, meta.getEmbedText(),"");
		DomHelper.writeAttr(element, MetaConstants.TEXT_HOLDFOCUS, meta.isHoldFocus(), false);
		DomHelper.writeAttr(element, MetaConstants.TEXT_USEFORMULAMODEL, meta.getUseFormulaModel(), false);
	}

}
