package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSliderProperties;

public class MetaSliderPropertiesAction extends DomPropertiesAction<MetaSliderProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaSliderProperties meta, int runType) {
		meta.setMaxPos(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_MAXPOS, MetaSliderProperties.DEFAULT_MAX_POS));
		meta.setMinPos(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_MINPOS, 0));
		meta.setStepValue(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_STEPVALUE, 0));
		meta.setBarColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_BARCOLOR, MetaSliderProperties.DEFAULT_BAR_COLOR));
		meta.setProgressColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_PROGRESSCOLOR, MetaSliderProperties.DEFAULT_PROGRESS_COLOR));
		meta.setAllowMultiSelection(DomHelper.readAttr(element, MetaConstants.SLIDER_ALLOWMULTISELECTION, false));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaSliderProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_MAXPOS, meta.getMaxPos(), MetaSliderProperties.DEFAULT_MAX_POS);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_MINPOS, meta.getMinPos(), 0);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_STEPVALUE, meta.getStepValue(), 0);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_BARCOLOR, meta.getBarColor(), MetaSliderProperties.DEFAULT_BAR_COLOR);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_PROGRESSCOLOR, meta.getProgressColor(), MetaSliderProperties.DEFAULT_PROGRESS_COLOR);
		DomHelper.writeAttr(element, MetaConstants.SLIDER_ALLOWMULTISELECTION, meta.isAllowMultiSelection(), false);
	}

}
