package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.JavaDataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGridDesignerProp;

public class MetaGridDesignerPropAction extends BaseDomAction<MetaGridDesignerProp> {

	@Override
	public void load(Document document, Element element, MetaGridDesignerProp meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDataType(JavaDataType.parse(DomHelper.readAttr(element, MetaConstants.GRID_DESIGNER_DATA_TYPE, JavaDataType.STR_USER_STRING)));
		meta.setEditorType(DomHelper.readAttr(element, MetaConstants.GRID_DESIGNER_EDITOR_TYPE, ""));
		meta.setEditorImpl(DomHelper.readAttr(element, MetaConstants.GRID_DESIGNER_EDITOR_IMPL, ""));
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.GRID_DESIGNER_ITEMKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaGridDesignerProp meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.GRID_DESIGNER_DATA_TYPE, JavaDataType.toString(meta.getDataType()), JavaDataType.STR_USER_STRING);
		DomHelper.writeAttr(element, MetaConstants.GRID_DESIGNER_EDITOR_TYPE, meta.getEditorType(), "");
		DomHelper.writeAttr(element, MetaConstants.GRID_DESIGNER_EDITOR_IMPL, meta.getEditorImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.GRID_DESIGNER_ITEMKEY, meta.getItemKey(), "");
	}

}
