package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.common.def.DictFilterType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;

public class MetaFilterAction extends BaseDomAction<MetaFilter> {

	@Override
	public void load(Document document, Element element, MetaFilter meta, int runType) {
		meta.setKey(DomHelper.readAttr(element,  MetaConstants.COMMON_KEY, ""));
		meta.setType(DictFilterType.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_TYPE, "")));
		meta.setExpression(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_EXPRESSION, ""));
		meta.setQuery(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_QUERY, ""));
		meta.setOp(FilterOptSign.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_OP, FilterOptSign.STR_AND)));
		meta.setCondition(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_CONDITION, ""));
		meta.setFilterDependency(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_DEPENDENCY, ""));
		meta.setFilterCaption(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_CAPTION, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_IMPL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaFilter meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");

		//TODO 写itemKey 的时候 需要判断 ， 如果是FieldValueFilter 并且 filter名和Dict的ItemKey一致 ， 则不用写入
		// DomHelper.writeAttribute(element, MetaConstants.DICT_FILTER_ITEMKEY,meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_TYPE, DictFilterType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_EXPRESSION, meta.getExpression(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_QUERY, meta.getQuery(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_OP, FilterOptSign.toString(meta.getOp()), FilterOptSign.STR_AND);
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_CONDITION, meta.getCondition() , "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_DEPENDENCY, meta.getFilterDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_CAPTION, meta.getFilterCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_IMPL, meta.getImpl(), "");
	}

}
