package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCustomProperties;

public class MetaCustomPropertiesAction extends DomPropertiesAction<MetaCustomProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaCustomProperties meta, int runType) {
		meta.setCellViewFactory(DomHelper.readAttr(element, MetaConstants.CELL_VIEW_FACTORY, ""));
		meta.setViewFactoryConfig(DomHelper.readAttr(element, MetaConstants.VIEW_FACTORY_CONFIG, ""));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaCustomProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.CELL_VIEW_FACTORY, meta.getCellViewFactory(), "");
		DomHelper.writeAttr(element, MetaConstants.VIEW_FACTORY_CONFIG, meta.getViewFactoryConfig(), "");
	}

}
