package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.BarCodeType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;

public class MetaBarCoderPropertiesAction extends DomPropertiesAction<MetaBarCoderProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaBarCoderProperties meta, int runType) {
		meta.setCodeType(BarCodeType
				.parse(DomHelper.readAttr(element, MetaConstants.BARCODER_CODETYPE, BarCodeType.STR_QR_CODE)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaBarCoderProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.BARCODER_CODETYPE, BarCodeType.toString(meta.getCodeType()),
				BarCodeType.STR_QR_CODE);
	}

}
