package com.bokesoft.yes.meta.persist.dom.form.component.control.navigationlist;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationListRow;

public class MetaNavigationListRowAction extends BaseDomAction<MetaNavigationListRow> {

	@Override
	public void load(Document document, Element element, MetaNavigationListRow meta, int runType) {
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.COMMON_FORECOLOR, ""));
		meta.setFontSize(DomHelper.readAttr(element, "FontSize", -1));
		meta.setHighlightColor(DomHelper.readAttr(element, MetaConstants.FORMAT_HIGHLIGHTCOLOR, ""));
		meta.setPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_PADDING, ""));
		meta.setLeftPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTPADDING, ""));
		meta.setRightPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, ""));
		meta.setTopPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPPADDING, ""));
		meta.setBottomPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, ""));
	}

	@Override
	public void save(Document document, Element element, MetaNavigationListRow meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORECOLOR, meta.getForeColor(), "");
		DomHelper.writeAttr(element, "FontSize", meta.getFontSize(), -1);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_HIGHLIGHTCOLOR, meta.getHighlightColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_PADDING, meta.getPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFTPADDING, meta.getLeftPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, meta.getRightPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOPPADDING, meta.getTopPadding(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, meta.getBottomPadding(), "");
	}

}

