package com.bokesoft.yes.meta.persist.dom.form.component.control.navigationlist;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.NavigationListSource;
import com.bokesoft.yigo.common.def.NavigationListStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationList;

public class MetaNavigationListAction  extends MetaComponentAction<MetaNavigationList>{

	@Override
	public void load(Document document, Element element, MetaNavigationList meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStyle(NavigationListStyle.parse(DomHelper.readAttr(element, MetaConstants.STYLE, NavigationListStyle.STR_TiledList)));
		meta.setSource(NavigationListSource.parse(DomHelper.readAttr(element, MetaConstants.NAVIGATIONLIST_SOURCE, NavigationListSource.STR_Self)));
		meta.setEntryPath(DomHelper.readAttr(element, MetaConstants.NAVIGATIONLIST_ENTRYPATH, ""));
		meta.setAllEntryFilter(DomHelper.readAttr(element, MetaConstants.NAVIGATIONLIST_ALLENTRYFILTER, true));
		meta.setColumnCount(DomHelper.readAttr(element, MetaConstants.COLUMNCOUNT, 3));
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.STR_CENTER)));
	}
	
	@Override
	public void save(Document document, Element element, MetaNavigationList meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.STYLE, NavigationListStyle.toString(meta.getStyle()), NavigationListStyle.STR_TiledList);
		DomHelper.writeAttr(element, MetaConstants.NAVIGATIONLIST_SOURCE, NavigationListSource.toString(meta.getSource()), NavigationListSource.STR_Self);
		DomHelper.writeAttr(element, MetaConstants.NAVIGATIONLIST_ENTRYPATH, meta.getEntryPath(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATIONLIST_ALLENTRYFILTER, meta.isAllEntryFilter(), true);
		DomHelper.writeAttr(element, MetaConstants.COLUMNCOUNT, meta.getColumnCount(), 3);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.toString(meta.getImageScaleType()), ImageScaleType.STR_CENTER);
	}
}
