package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.editview.MetaEditViewAction;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaGallery;

public class MetaGalleryAction extends MetaEditViewAction<MetaGallery> {
	@Override
	public void load(Document document, Element element, MetaGallery meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setRepeat(DomHelper.readAttr(element, MetaConstants.GALLERY_REPEAT, false));
		meta.setCellGap(DomHelper.readAttr(element, MetaConstants.GALLERY_CELLGAP, 0));
		meta.setIndicator(DomHelper.readAttr(element, MetaConstants.GALLERY_INDICATOR, true));
		meta.setIndicatorLocation(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.GALLERY_INDICATOR_LOCATION, "")));
		meta.setPagination(DomHelper.readAttr(element, MetaConstants.GALLERY_PAGINATION, false));
		meta.setDisplayRatio(TypeConvertor.toBigDecimal(DomHelper.readAttr(element, MetaConstants.GALLERY_DISPLAY_RATIO, "1")).floatValue());
	}

	@Override
	public void save(Document document, Element element, MetaGallery meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_REPEAT, meta.isRepeat(), false);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_CELLGAP, meta.getCellGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_INDICATOR, meta.isIndicator(), true);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_INDICATOR_LOCATION, HAlignment.toString(meta.getIndicatorLocation()), "");
		DomHelper.writeAttr(element, MetaConstants.GALLERY_PAGINATION, meta.isPagination(), false);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_DISPLAY_RATIO, meta.getDisplayRatio()+"", "1.0");
	}
}
