package com.bokesoft.yes.meta.persist.dom.form.component.control.gantt;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaRelationship;

public class MetaRelationshipAction extends BaseDomAction<MetaRelationship> {

	@Override
	public void load(Document document, Element element, MetaRelationship meta, int runType) {
		meta.setTableKey(DomHelper.readAttr(element, "TableKey", ""));
		meta.setPredecessor(DomHelper.readAttr(element, "Predecessor", ""));
		meta.setSuccessor(DomHelper.readAttr(element, "Successor", ""));
		meta.setType(DomHelper.readAttr(element, "Type", ""));
	}

	@Override
	public void save(Document document, Element element, MetaRelationship meta, int runType) {
		DomHelper.writeAttr(element, "TableKey", meta.getTableKey(), "");
		DomHelper.writeAttr(element, "Predecessor", meta.getPredecessor(), "");
		DomHelper.writeAttr(element, "Successor", meta.getSuccessor(), "");
		DomHelper.writeAttr(element, "Type", meta.getType(), "");
	}

}
