package com.bokesoft.yes.meta.persist.dom.form.component.control.gantt;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttColumn;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttRow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaGanttRowAction extends BaseDomAction<MetaGanttRow> {

	@Override
	public void load(Document document, Element element, MetaGanttRow meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setStartTime(DomHelper.readAttr(element, "StartTime", ""));
		meta.setEndTime(DomHelper.readAttr(element, "EndTime", ""));
		meta.setCssClass(DomHelper.readAttr(element, "CssClass", ""));
		meta.setVisible(DomHelper.readAttr(element, "Visible", ""));
		meta.setText(DomHelper.readAttr(element, "Text", ""));
		meta.setShowRelation(DomHelper.readAttr(element, "ShowRelation", false));
		meta.setShape(DomHelper.readAttr(element, "Shape", ""));
	}

	@Override
	public void save(Document document, Element element, MetaGanttRow meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, "StartTime", meta.getStartTime(), "");
		DomHelper.writeAttr(element, "EndTime", meta.getEndTime(), "");
		DomHelper.writeAttr(element, "CssClass", meta.getCssClass(), "");
		DomHelper.writeAttr(element, "Visible", meta.getVisible(), "");
		DomHelper.writeAttr(element, "Text", meta.getText(), "");
		DomHelper.writeAttr(element, "ShowRelation", meta.getShowRelation(), false);
		DomHelper.writeAttr(element, "Shape", meta.getShape(), "");
	}
}
