package com.bokesoft.yes.meta.persist.dom.form.component;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.MetaCustom;

public class MetaCustomAction extends MetaComponentAction<MetaCustom> {
	@Override
	public void load(Document document, Element element, MetaCustom meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTag(DomHelper.readAttr(element, MetaConstants.COMMON_TAG, ""));
		meta.setUserData(DomHelper.readAttr(element, MetaConstants.TEMPLATE_USERDATA, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.CUSTOM_IMPL, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaCustom meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_TAG, meta.getTag(), "");
		DomHelper.writeAttr(element, MetaConstants.TEMPLATE_USERDATA, meta.getUserData(), "");
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_IMPL, meta.getImpl(), "");
	}
}
