package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaTimerTask;

public class MetaTimerTaskAction extends MetaBaseScriptAction<MetaTimerTask> {

	@Override
	public void load(Document document, Element element, MetaTimerTask meta,
			int runType) {
		super.load(document, element, meta, runType);
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDelay(DomHelper.readAttr(element, MetaConstants.TIMERTASK_DELAY, 0));
		meta.setRepeat(DomHelper.readAttr(element, MetaConstants.TIMERTASK_REPEAT, false));
		meta.setPeriod(DomHelper.readAttr(element, MetaConstants.TIMERTASK_PERIOD, 60000));
		meta.setStartOnload(DomHelper.readAttr(element, MetaConstants.TIMERTASK_STARTONLOAD, true));
		meta.setThrowException(DomHelper.readAttr(element, MetaConstants.TIMERTASK_THROWEXCEPTION, true));
	}

	@Override
	public void save(Document document, Element element, MetaTimerTask meta,
			int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TIMERTASK_DELAY, meta.getDelay(), 0);
		DomHelper.writeAttr(element, MetaConstants.TIMERTASK_REPEAT, meta.isRepeat(), false);
		DomHelper.writeAttr(element, MetaConstants.TIMERTASK_PERIOD, meta.getPeriod(), 60000);
		DomHelper.writeAttr(element, MetaConstants.TIMERTASK_STARTONLOAD, meta.startOnload(), true);
		DomHelper.writeAttr(element, MetaConstants.TIMERTASK_THROWEXCEPTION, meta.isThrowException(), true);
	}

}
