package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateCellType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelCellAction extends BaseDomAction<MetaExcelCell> {

	@Override
	public void load(Document document, Element element, MetaExcelCell meta, int runType) {
		meta.setCellIndex(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_CELLINDEX, -1));
		meta.setSourceType(ExcelTemplateCellType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_SOURCETYPE, ExcelTemplateCellType.STR_Field)));
		meta.setDefinition(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_DEFINITION, ""));
		meta.setMergedColumnSpan(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_MERGEDCOLUMNSPAN, 1));
		meta.setMergedRowSpan(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_MERGEDROWSPAN, 1));
		meta.setColumnExpand(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_COLUMNEXPAND, false));
		meta.setTableKey(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_TABLEKEY, ""));
		meta.setGroupLevel(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_GROUPLEVEL, 0));
		meta.setGroupPosition(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_GROUPPOSITION, ""));
		meta.setGroupHeadRowCount(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_GROUPHEADROWCOUNT, 0));
		meta.setGroupTailRowCount(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_GROUPTAILROWCOUNT, 0));
		meta.setDetailLinked(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_DETAILLINKED, false));
		meta.setIgnoreExport(DomHelper.readAttr(element, MetaExcelTemplateConstants.CELL_IGNOREEXPORT, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExcelCell meta, int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_CELLINDEX, meta.getCellIndex(), -1);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_SOURCETYPE, ExcelTemplateCellType.toString(meta.getSourceType()), ExcelTemplateCellType.STR_Field);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_DEFINITION, meta.getDefinition(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_MERGEDCOLUMNSPAN, meta.getMergedColumnSpan(), 1);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_MERGEDROWSPAN, meta.getMergedRowSpan(), 1);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_COLUMNEXPAND, meta.isColumnExpand(), false);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_GROUPLEVEL, meta.getGroupLevel(), 0);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_GROUPPOSITION, meta.getGroupPosition(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_GROUPHEADROWCOUNT, meta.getGroupHeadRowCount(), 0);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_GROUPTAILROWCOUNT, meta.getGroupTailRowCount(), 0);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_DETAILLINKED, meta.isDetailLinked(), false);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.CELL_IGNOREEXPORT, meta.getIgnoreExport(), "");
	}
}
