package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.ExcelCellBorderType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelBorder;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelBorderAction extends BaseDomAction<MetaExcelBorder> {
	@Override
	public void load(Document document, Element element, MetaExcelBorder meta, int runType) {
		meta.setLeftStyle(ExcelCellBorderType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_LEFTSTYLE, ExcelCellBorderType.STR_Border_None)));
		meta.setLeftColor(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_LEFTCOLOR, ""));
		meta.setTopStyle(ExcelCellBorderType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_TOPSTYLE, ExcelCellBorderType.STR_Border_None)));
		meta.setTopColor(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_TOPCOLOR, ""));
		meta.setRightStyle(ExcelCellBorderType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_RIGHTSTYLE, ExcelCellBorderType.STR_Border_None)));
		meta.setRightColor(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_RIGHTCOLOR, ""));
		meta.setBottomStyle(ExcelCellBorderType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_BOTTOMSTYLE, ExcelCellBorderType.STR_Border_None)));
		meta.setBottomColor(DomHelper.readAttr(element, MetaExcelTemplateConstants.BORDER_BOTTOMCOLOR, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExcelBorder meta, int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_LEFTSTYLE, ExcelCellBorderType.toString(meta.getLeftStyle()), ExcelCellBorderType.STR_Border_None);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_LEFTCOLOR, meta.getLeftColor(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_TOPSTYLE, ExcelCellBorderType.toString(meta.getTopStyle()), ExcelCellBorderType.STR_Border_None);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_TOPCOLOR, meta.getTopColor(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_RIGHTSTYLE, ExcelCellBorderType.toString(meta.getRightStyle()), ExcelCellBorderType.STR_Border_None);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_RIGHTCOLOR, meta.getRightColor(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_BOTTOMSTYLE, ExcelCellBorderType.toString(meta.getBottomStyle()), ExcelCellBorderType.STR_Border_None);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.BORDER_BOTTOMCOLOR, meta.getBottomColor(), "");
	}

}
