package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaTableSplit;

public class MetaTableSplitAction extends BaseDomAction<MetaTableSplit> {

	@Override
	public void load(Document document, Element element, MetaTableSplit meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setOIDColumnKey(DomHelper.readAttr(element, MetaConstants.TABLESPLIT_OIDCOLUMNKEY, ""));
		meta.setDetailOIDColumnKey(DomHelper.readAttr(element, MetaConstants.TABLESPLIT_DETAILOIDCOLUMNKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTableSplit meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLESPLIT_OIDCOLUMNKEY, meta.getOIDColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLESPLIT_DETAILOIDCOLUMNKEY, meta.getDetailOIDColumnKey(), "");
	}

}
