package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaTable;

/**
 * 数据表对象载入和保存时的相关动作
 *
 * @author 张坤
 * @since YES3.1
 */
public class MetaTableExtAction extends BaseDomAction<MetaTable> {

    @Override
    public void load(Document document, Element element, MetaTable meta, int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
        meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
        meta.setPersist(DomHelper.readAttr(element, MetaConstants.TABLE_PERSIST, true));
        meta.setTableMode(TableMode.parse(DomHelper.readAttr(element, MetaConstants.TABLE_MODE, TableMode.STR_HEAD)));
        meta.setSourceType(TableSourceType.parse(DomHelper.readAttr(element, MetaConstants.TABLE_SOURCETYPE, TableSourceType.STR_DATA_OBJECT)));
        meta.setDBTableName(DomHelper.readAttr(element, MetaConstants.TABLE_DBTABLENAME, null));
        meta.setParentKey(DomHelper.readAttr(element, MetaConstants.TABLE_PARENT_KEY, null));
        meta.setHidden(DomHelper.readAttr(element, MetaConstants.TABLE_HIDDEN, false));
        meta.setUniquePrimary(DomHelper.readAttr(element, MetaConstants.TABLE_UNIQUE_PRIMARY, false));
        meta.setOrderBy(DomHelper.readAttr(element, MetaConstants.TABLE_ORDERBY, null));
        meta.setFormula(DomHelper.readAttr(element, MetaConstants.TABLE_FORMULA, null));
        meta.setImpl(DomHelper.readAttr(element, MetaConstants.TABLE_IMPL, null));
        meta.setLoadInMidUse(DomHelper.readAttr(element, MetaConstants.TABLE_LOAD_IN_MID_USE, true));
        meta.setLazyLoad(DomHelper.readAttr(element, MetaConstants.TABLE_LAZY_LOAD, false));
        meta.setIndexPrefix(DomHelper.readAttr(element, MetaConstants.TABLE_INDEXPREFIX, null));
        meta.setPrimaryKey(DomHelper.readAttr(element, MetaConstants.TABLE_PRIMARYKEY, null));
        meta.setGroupBy(DomHelper.readAttr(element, MetaConstants.TABLE_GROUPBY, null));
        meta.setUseCursor(DomHelper.readAttr(element, MetaConstants.TABLE_USE_CURSOR, false));
        meta.setRefreshFilter(DomHelper.readAttr(element, MetaConstants.TABLE_REFRESH_FILTER, false));
        meta.setHisTableName(DomHelper.readAttr(element, MetaConstants.TABLE_HISTABLENAME, null));
        meta.setConvertor(DomHelper.readAttr(element, MetaConstants.TABLE_CONVERTOR, null));
    }

    @Override
    public void save(Document document, Element element, MetaTable meta, int runType) {
    }
}
