package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.MetaMap;

public class MetaMapAction extends BaseDomAction<MetaMap> {

	@Override
	public void load(Document document, Element element, MetaMap meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setSrcDataObjectKey(DomHelper.readAttr(element, MetaMapConstants.SRC_DATA_OBJECT_KEY, ""));
		meta.setTgtDataObjectKey(DomHelper.readAttr(element, MetaMapConstants.TGT_DATA_OBJECT_KEY, ""));
		meta.setMapRelationValue(DomHelper.readAttr(element, MetaMapConstants.MAP_RELATION_VALUE, true));
		meta.setMaxPushValue(DomHelper.readAttr(element, MetaMapConstants.MAX_PUSH_VALUE, ""));
		meta.setMinPushValue(DomHelper.readAttr(element, MetaMapConstants.MIN_PUSH_VALUE, ""));
		meta.setAllowSurplus(DomHelper.readAttr(element, MetaMapConstants.ALLOW_SURPLUS, false));
		meta.setRemainderPushValue(DomHelper.readAttr(element, MetaMapConstants.REMAINDER_PUSH_VALUE, ""));
		meta.setAllowRemainderPush(DomHelper.readAttr(element, MetaMapConstants.ALLOW_REMAINDER_PUSH, true));
		meta.setMapCondition(DomHelper.readAttr(element, MetaMapConstants.MAP_CONDITION, "")); 
		meta.setPullDataOnly(DomHelper.readAttr(element, MetaMapConstants.MAP_PULL_DATA_ONLY, false));
		meta.setMarkMapCount(DomHelper.readAttr(element, MetaMapConstants.MAP_MARK_MAP_COUNT, true));
	}

	@Override
	public void save(Document document, Element element, MetaMap meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaMapConstants.SRC_DATA_OBJECT_KEY, meta.getSrcDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.TGT_DATA_OBJECT_KEY, meta.getTgtDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.MAP_RELATION_VALUE, meta.getMapRelationValue(), true);
		DomHelper.writeAttr(element, MetaMapConstants.MAX_PUSH_VALUE, meta.getMaxPushValue(), "");
		DomHelper.writeAttr(element, MetaMapConstants.MIN_PUSH_VALUE, meta.getMinPushValue(), "");
		DomHelper.writeAttr(element, MetaMapConstants.ALLOW_SURPLUS, meta.getAllowSurplus(), false);
		DomHelper.writeAttr(element, MetaMapConstants.ALLOW_SURPLUS, meta.getAllowSurplus(), false);
		DomHelper.writeAttr(element, MetaMapConstants.REMAINDER_PUSH_VALUE, meta.getRemainderPushValue(), "");
		DomHelper.writeAttr(element, MetaMapConstants.ALLOW_REMAINDER_PUSH, meta.getAllowRemainderPush(), true);
		DomHelper.writeAttr(element, MetaMapConstants.MAP_CONDITION, meta.getMapCondition(), ""); 
		DomHelper.writeAttr(element, MetaMapConstants.MAP_PULL_DATA_ONLY, meta.isPullDataOnly(), false);
		DomHelper.writeAttr(element, MetaMapConstants.MAP_MARK_MAP_COUNT, meta.isMarkMapCount(), true);
	}
}
