package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.diagram.MetaFeedbackCollection;

public class MetaFeedbackCollectionAction extends BaseDomAction<MetaFeedbackCollection> {

	@Override
	public void load(Document document, Element element,
			MetaFeedbackCollection meta, int runType) {
		meta.setStatusFieldKey(DomHelper.readAttr(element, MetaMapConstants.FEEDBACK_STATUSFIELDKEY, ""));
		meta.setStatusValue(DomHelper.readAttr(element, MetaMapConstants.FEEDBACK_STATUSVALUE, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaMapConstants.FEEDBACK_CONDITION, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaFeedbackCollection meta, int runType) {
		DomHelper.writeAttr(element, MetaMapConstants.FEEDBACK_STATUSFIELDKEY, meta.getStatusFieldKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FEEDBACK_STATUSVALUE, meta.getStatusValue(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FEEDBACK_CONDITION, meta.getCondition(), "");
	}

}
