package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.MetaStatus;

public class MetaStatusAction extends BaseDomAction<MetaStatus> {

	@Override
	public void load(Document document, Element element,
			MetaStatus meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.STATUS_VALUE, -1));
		meta.setStandalone(DomHelper.readAttr(element, MetaConstants.STATUS_STANDALONE, false));
	}

	@Override
	public void save(Document document, Element element,
			MetaStatus meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.STATUS_VALUE, meta.getValue(), -1);
		DomHelper.writeAttr(element, MetaConstants.STATUS_STANDALONE, meta.isStandalone(), false);
	}

}
